

###### (Automatically generated documentation)

# Create Typical DOE Building from Model

## Description
Takes a model with space and stub space types, and assigns constructions, schedules, internal loads, hvac, and other loads such as exterior lights and service water heating.

## Modeler Description
It is important that the template argument chosen for this measure is in line with the buding types for the stub space types of the model passed in.

## Measure Type
ModelMeasure

[//]: # (Commenting out until it works in SDK)
[//]: # (## Taxonomy)
[//]: # ()

___
## Table of Contents
- [Measure Overview](#measure-overview)<br/>
- [DOE Template Mapping](#doe-template-and-building-type-mapping)<br/>
- [HVAC Configuration Arguments](#hvac-configuration-arguments)<br/>
- [Exterior Lighting Arguments](#exterior-lighting-arguments)<br/>
- [Bool Arguments to Enable/Disable Elements of This Measure](#bool-arguments-to-enabledisable-elements-of-this-measure)<br/>
- [Hours of Operation Arguments](#hours-of-operation-arguments)<br/>
- [Other Arguments](#other-arguments)<br/>
- [Development Comments](#development-comments)<br/>
- [Automatically Generated Argument List](#arguments)<br/>

## Measure Overview

While this measure has many arguments, they all have default values so you can start using it to get familiar with out without using the arguments. What is important is that the model passed in contains spaces with stub space types assigned. In addition to choice arguments, this measure has a number of bool arguments allowing the measure to be customized to meet your needs or to be split into two parts with other measures add in the model. You can for example use this to add constructions only, or to add everything else but leave constructions alone. An example use case for splitting this apart and adding other measures between would be to apply energy efficiency measures for new construction. The HVAC system should be added after the EE measures because an autosizing simulation is run to set the system equipment efficiencies for the selected template.


## DOE Template and Building Type Mapping

- Templates:
  - DOE Ref Pre-1980
  - DOE Ref 1980 - 2004
  - 90.1-2004
  - 90.1-2007
  - 90.1-2010
  - 90.1-2013
- Building Types:
  - SecondarySchool
  - PrimarySchool
  - SmallOffice
  - MediumOffice
  - LargeOffice
  - SmallHotel
  - LargeHotel
  - Warehouse
  - RetailStandalone
  - RetailStripmall
  - QuickServiceRestaurant
  - FullServiceRestaurant
  - MidriseApartment
  - HighriseApartment
  - Hospital
  - Outpatient
  - SuperMarket

[//]: # (Would be nice to make these lists dynamic from the measure to they don't become outdated)

## HVAC Configuration Arguments

- `HVAC System Type` can be set to 'Inferred', 'Ideal Air Loads', or more than 50 additional system types. When choosing Inferred additional arguments listed below will impact the selected system type as elements of the seed model.

- `HVAC System Delivery Type` can be set to `Forced Air` or `Hydronic`

- `HVAC Heating Source` can be set to `Electricity`, `NaturalGas`, `DistrictHeating`, or `DistrictAmbient`

- `HVAC Cooling Source` can be set to `Electricity`, or `DistrictCooling`

- `Service Water Heating Source`can be set to `Inferred`, `NaturalGas`, `Electricity`, or `HeatPump`.

- `Kitchen Exhaust MakeUp Air Calculation Method` is used to determine if makeup air is modeled for kitchen exhaust and what zone that comes from. While the default choice of `Adajcent` makes sence for custom user geometry, if the geometry was autogenerated without representing an actual plan, you can set makup air to come from the `Largest Zone`. `None` is also an option, which disables makeup air.

## Exterior Lighting Arguments

- `Exterior Lighting Zone` is used to identify the exterior lighting allowances based on how urban or rural the site for the buidling is. The `Template also impacts the target value.

- `Onsite Parking Fraction` can reduce or eliminate the amount of exterior lighting for parking added to the model. This wil not reduce exterior facade, walkway, or entry lighting.

## Bool Arguments to Enable/Disable Elements of This Measure

The following is a list of aruments for elements of the model that can be enabled or disabled for the measure.
- `Add Constructions to Model`
- `Add Space Type Loads to Model`
- `Add Elevators to Model`. This will only be added to buildings with more than one story. Number of floors will be used to determine the elevator type, and the number of occpants can determine both the number of elevators and can impact the schedule. To avoid large jumps in parametric analyses, the number of elevators is a double instead of an integer, but will never be less than 1.0 for multi-story buildings, but can for example be 2.6 or 1.5 elevators, instead of just 1 or 2. The logic used isn't depending on a space or space type existing for elevators. The space laod will be added to the largest space on the first story. Fraciton of heat lost will be set to 1.0 for traction elevators.
- `Add Internal Mass to Model`
- `Add Exterior Lights to Model`
- `Add Exhaust Fans to Model`
- `Add Service Water Heating to Model`
- `Add Thermostats`
- `Add HVAC System to Model`. This may add a secondary system for zones with internal loads or schedules that are dis-similar from the typical zones. For thermal zones on the primary zone, where  multi-zone air loops are added, one air loop will be added for each building story. A sizing run will be performed however the elements in the model will stay autosized. The sizing run is to identify the proper target system efficency.
- `Add Refrigeration to Model`

## Hours of Operation Arguments

There are three arguments each for weekday and weekend behavior. In each case there are the following arguments.

- Bool argument to enable/dsiable altering of weekdays or weekends
- Operating hours start time
- Operating hours duration


## Other Arguments

- `Use Upstream Argument Values` can be left at the default value of true for most cases. This argument shows up in a number of measures, and then intent is to enable the synchronization of arguments that may be used as a variable in a parametric study across multiple measures. Generally measure ahve uqniue argument names that don't exist, but some such as `Template` are used frequently. This argument, when set to true, will use the value of `Template` from an earlier measure in the workflow, if found, in place of what is entered as the value for this measure.
- `Unmet Hours Tolerance` is used to change the tolerance used in EnergyPlus for unmet heating and cooling hours.
- `Clean Model of non-geometry objects` shoudl be set to false when you have a non-empty model with objects that you want to maintain. If you have split this measure in two the second instance of this should have it set to false or it will overwrite elements made by the earlier measure.
- `Enable Daylight Savings` will change daylighting saving to true when enabled.

## Development Comments

This measure relies on the openstudio-standards gem which is included in the OpenStudio CLI as well as a number of resources files listed below that are contained in the measure's `resources` directory. Other than the arguments almost none of the measure code is in the measure.rb file. The resource files are used by a number of measures and should be udpated from the shared library and not within this measure.
 - os_lib_model_generation.rb
 - os_lib_helper_methods.rb
 - os_lib_helper_methods.rb

*(Automatically generated argument information follows)*## Arguments


### Target Standard

**Name:** template,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### HVAC System Type

**Name:** system_type,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### HVAC System Delivery Type
How the HVAC system delivers heating or cooling to the zone.
**Name:** hvac_delivery_type,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### HVAC Heating Source
The primary source of heating used by HVAC systems in the model.
**Name:** htg_src,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### HVAC Cooling Source
The primary source of cooling used by HVAC systems in the model.
**Name:** clg_src,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Service Water Heating Source
The primary source of heating used by SWH systems in the model.
**Name:** swh_src,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Kitchen Exhaust MakeUp Air Calculation Method
Determine logic to identify dining or cafe zones to provide makeup air to kitchen exhaust.
**Name:** kitchen_makeup,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Exterior Lighting Zone
Identify the Exterior Lighting Zone for the Building Site.
**Name:** exterior_lighting_zone,
**Type:** Choice,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Constructions to Model
Construction Set will be applied to entire building
**Name:** add_constructions,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Space Type Loads to Model
Populate existing space types in model with internal loads.
**Name:** add_space_type_loads,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Elevators to Model
Elevators will be add directly to space in model vs. being applied to a space type.
**Name:** add_elevators,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Internal Mass to Model
Adds internal mass to each space.
**Name:** add_internal_mass,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Exterior Lights to Model
Multiple exterior lights objects will be added for different classes of lighting such as parking and facade.
**Name:** add_exterior_lights,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Onsite Parking Fraction
If set to 0 no exterior lighting for parking will be added
**Name:** onsite_parking_fraction,
**Type:** Double,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Exhaust Fans to Model
Depending upon building type exhaust fans can be in kitchens, restrooms or other space types
**Name:** add_exhaust,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Service Water Heating to Model
This will add both the supply and demand side of service water heating.
**Name:** add_swh,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Thermostats
Add Thermostat to model based on Space Type Standards information of spaces assigned to thermal zones.
**Name:** add_thermostat,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add HVAC System to Model
Add HVAC System to the model
**Name:** add_hvac,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Add Refrigeration to Model
Add refrigeration cases and walkins model
**Name:** add_refrigeration,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Modify weekday hours of operation
Modify the weekday hours of operation in the model.
**Name:** modify_wkdy_op_hrs,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Weekday Operating Hours Start Time
Enter 24 hour values with fractional values converted to minutes. e.g. 17.25 = 5:15pm. Only used if Modify weekday hours of operation is true.
**Name:** wkdy_op_hrs_start_time,
**Type:** Double,
**Units:** Hours,
**Required:** true,
**Model Dependent:** false

### Weekday Operating Hours Duration
Length of weekday operating hours. Enter 24 hour values with fractional values converted to minutes. e.g. 17.25 = 5:15pm. Only used if Modify weekday hours of operation is true.
**Name:** wkdy_op_hrs_duration,
**Type:** Double,
**Units:** Hours,
**Required:** true,
**Model Dependent:** false

### Modify weekend hours of operation
Modify the weekend hours of operation in the model.
**Name:** modify_wknd_op_hrs,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Weekend Operating Hours Start Time
Enter 24 hour values with fractional values converted to minutes. e.g. 17.25 = 5:15pm.  Only used if Modify weekend hours of operation is true.
**Name:** wknd_op_hrs_start_time,
**Type:** Double,
**Units:** Hours,
**Required:** true,
**Model Dependent:** false

### Weekend Operating Hours Duration
Length of weekend operating hours. Enter 24 hour values with fractional values converted to minutes. e.g. 17.25 = 5:15pm.  Only used if Modify weekend hours of operation is true.
**Name:** wknd_op_hrs_duration,
**Type:** Double,
**Units:** Hours,
**Required:** true,
**Model Dependent:** false

### Unmet Hours Tolerance
Set the thermostat setpoint tolerance for unmet hours in degrees Rankine
**Name:** unmet_hours_tolerance,
**Type:** Double,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Clean Model of non-geometry objects
Only removes objects of type that are selected to be added.
**Name:** remove_objects,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Use Upstream Argument Values
When true this will look for arguments or registerValues in upstream measures that match arguments from this measure, and will use the value from the upstream measure in place of what is entered for this measure.
**Name:** use_upstream_args,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false

### Enable Daylight Savings
By default this will force daylight savings to be enabled. Set to false if in a location where DST is not followed, or if needed for specific use case.
**Name:** enable_dst,
**Type:** Boolean,
**Units:** ,
**Required:** true,
**Model Dependent:** false




